/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base;

import filenet.vw.api.VWException;
import filenet.vw.api.VWWorkflowRuntimeId;
import filenet.vw.base.StringUtils;
import filenet.vw.base.logging.Logger;
import java.util.Date;

public class VWVersion {
    protected static Logger logger = Logger.getLogger("filenet.vw.base");
    protected static final String m_className = "VWVersion";
    private static final String MARKER = "~~";
    private static final String DELIM = "\t";
    private static final int VW_VALID_VERSIONS = 4;
    private String connectionPoint = null;
    private String m_stringVersion = null;
    private String version = null;
    private int versionNum = -1;
    private String serviceName = null;
    private int isolatedRegion = -1;
    private int workSpaceId = -1;
    private int workClassId = -1;
    private Date timeStamp;
    private String m_workClassName = null;

    public static String _get_FILE_DATE() {
        return "$Date:   25 Apr 2007 11:04:10  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.9  $";
    }

    public String getWorkClassName() {
        return this.m_workClassName;
    }

    public void setWorkClassName(String s) {
        this.m_workClassName = s;
    }

    public String getVersion() {
        return this.version;
    }

    public int getVersionNum() {
        return this.versionNum;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public int getIsolatedRegion() {
        return this.isolatedRegion;
    }

    public int getWorkSpaceId() {
        return this.workSpaceId;
    }

    public int getWorkClassId() {
        return this.workClassId;
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public String getConnectionPoint() {
        return this.connectionPoint;
    }

    public void resetWorkspaceId() {
        this.workSpaceId = -1;
    }

    private void parse(String s) throws VWException {
        if (s == null || !s.startsWith(MARKER)) {
            throw new VWException("filenet.vw.base.VWVersion.invalidVersion", "Invalid VW Version. {0}", s);
        }
        String[] res = StringUtils.split(s = s.substring(MARKER.length()), DELIM);
        if (res == null) {
            throw new VWException("filenet.vw.base.VWVersion.invalidVersion", "Invalid VW Version. {0}", s);
        }
        this.version = res[0];
        try {
            this.versionNum = Integer.parseInt(this.version);
        }
        catch (Exception ex) {
            throw new VWException("filenet.vw.base.VWVersion.invalidVersion", "Invalid VW Version. {0}", s);
        }
        if (this.versionNum < 1 || this.versionNum > 4) {
            throw new VWException("filenet.vw.base.VWVersion.invalidVersion", "Invalid VW Version. {0}", s);
        }
        int index = 1;
        if (this.versionNum == 3 || this.versionNum == 4) {
            this.connectionPoint = res[index++];
        }
        this.serviceName = res[index++];
        try {
            this.isolatedRegion = Integer.parseInt(res[index++]);
            this.workSpaceId = Integer.parseInt(res[index++]);
            this.workClassId = Integer.parseInt(res[index++]);
            long t = Long.parseLong(res[index++]) * 1000L;
            this.timeStamp = new Date(t);
            if (logger.isFinest()) {
                logger.finest(m_className, "parse", "time as Date String = " + this.timeStamp.toString());
            }
        }
        catch (Exception e) {
            throw new VWException("filenet.vw.base.VWVersion.invalidVersion", "Invalid VW Version. {0}", s);
        }
    }

    public VWVersion(VWWorkflowRuntimeId runtimeId) {
        if (runtimeId != null) {
            String m_method = "ctor:runtimeId:" + runtimeId.toString();
            this.versionNum = 1;
            this.version = Integer.toString(this.versionNum);
            this.serviceName = runtimeId.getServiceName();
            this.isolatedRegion = runtimeId.getIsolatedRegion();
            this.workSpaceId = runtimeId.getWorkSpaceId();
            this.workClassId = runtimeId.getWorkClassId();
            this.timeStamp = runtimeId.getRegionTimeStamp();
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "time as Date String = " + this.timeStamp.toString());
            }
            long t = this.timeStamp.getTime();
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "time as long = " + Long.toString(t));
            }
        } else if (logger.isFinest()) {
            logger.finest(m_className, "ctor:runtimeId", "NULL???");
        }
    }

    public VWVersion(String s) throws VWException {
        this.parse(s);
        this.m_stringVersion = s;
    }

    public String toStringEx() {
        return "version=" + this.version + ",service=" + this.serviceName + ",ir=" + Integer.toString(this.isolatedRegion) + ",wsId=" + Integer.toString(this.workSpaceId) + ",wcId=" + Integer.toString(this.workClassId) + ",ts=" + this.timeStamp.toString() + ", cp=" + this.connectionPoint;
    }

    public String toString() {
        if (this.m_stringVersion != null) {
            return this.m_stringVersion;
        }
        return MARKER + this.version + (this.versionNum == 3 ? DELIM + this.connectionPoint : "") + DELIM + this.serviceName + DELIM + Integer.toString(this.isolatedRegion) + DELIM + Integer.toString(this.workSpaceId) + DELIM + Integer.toString(this.workClassId) + DELIM + Long.toString(this.timeStamp.getTime() / 1000L);
    }

    public static void main(String[] args) {
        String[] tests = new String[]{"~~1\tservice\t1\t100\t2000\t1073458026056", "~~1\tCPINVALID\tservice\t1\t200\t3000\t1073458026057", "~~3\tCP\tservice\t1\t200\t4000\t1073458026058", "~~4\tCP\tservice\t1\t200\t4000\t1073458026058", "~~3\tINVALIDVWService0:hqepbpe2:FileNet\t1\t181\t6\t1073458026000"};
        for (int i = 0; i < tests.length; ++i) {
            try {
                String s = tests[i];
                System.out.println("-----------------\n" + s);
                VWVersion v = new VWVersion(s);
                System.out.println("Gotback:" + v.toString());
                System.out.println("Parts = " + v.toStringEx());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.exit(0);
    }
}

